METHOD  FMpCmdMConvert()                                          '
'--------------------------------------------------------------------------------------------------+
'- MConvert - Convert macros to use the Built-In macro variables                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL fcmd, t, X, pDiag AS STRING, RCA AS RCArea                  '
LOCAL i, j, V, lclNF, FNum, ChgCnt, ONCE, AllCount1, AllCount2 AS LONG
LOCAL OldFile, NewFile, CCmd AS STRING                            '
DIM FromTxt(1 TO 150) AS STRING                                   '
DIM ToTxt(1 TO 150) AS STRING                                     '
   MEntry
   '-----------------------------------------------------------------------------------------------+
   '- Load the tables of FROM/TO strings                                                           |
   '-----------------------------------------------------------------------------------------------+
   FOR i = 1 TO DATACOUNT STEP 2                                  ' Load the From/To tables
      INCR ChgCnt                                                 '
      FromTxt(ChgCnt) = READ$(i): ToTxt(ChgCnt) = READ$(i + 1)    '
   NEXT i                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Spin through the displayed files                                                             |
   '-----------------------------------------------------------------------------------------------+
   gfInterrupt = %False                                           '
   DispInterrupt("Click to Interrupt convert", "Processing file: ")   ' Display the Interrupt popup

   FOR i = 1 TO gFMDCtr                                           ' Lets see if any lines were selected
      IF gfInterrupt THEN EXIT FOR                                '
      IF gFMD(i).Type(%FEntry, %FFLEntry) THEN                    ' Existing File?
         '-----------------------------------------------------------------------------------------+
         '- Create the Old/New file names                                                          |
         '-----------------------------------------------------------------------------------------+
         OldFile = gFMD(i).FullPath                               ' Get a file name
         NewFile = gFMD(i).DPath + "Converted\"                   ' Build the new name
         IF ISFALSE ISFOLDER(NewFile) THEN MKDIR Newfile          ' Ensure folder is created
         NewFile += MID$(OldFile, INSTR(-1, OldFile, "\") + 1)    ' Add the filename to the path

         CONTROL SET TEXT ghIntr, %INTERRUPT_TEXT2, RTRIM$(OldFile)  '
         INCR AllCount1                                           '
         CONTROL SET TEXT ghIntr, %INTERRUPT_TEXT3, "Processed: " + FORMAT$(AllCount1)   '
         DIALOG DOEVENTS 0                                        ' Let others process
         RESET gLoopCtr                                           ' Reset LoopCtr to avoid treating as a loop
         me.LInitTxtData()                                        ' Initialize our Text area
         FCB.SetupFN(OldFile, %ProfGetY, RCA)                     ' Setup filename
         IF RCA.RC <> 0 THEN ITERATE FOR                          ' Profile failed, skip
         IF me.InitaFile(%True) THEN ITERATE FOR                  ' Initialize file stuff, honor SKIP
         IF UCASE$(RIGHT$(OldFile, 6)) <> ".MACRO" THEN GOTO Cpyit ' Skip any non macros
         me.RangeSetRange(2, LastLine - 1)                        ' Everything for search
         '-----------------------------------------------------------------------------------------+
         '- Now do all the change commands                                                         |
         '-----------------------------------------------------------------------------------------+
         ONCE = %False                                            ' Reset
         FOR v = 1 TO ChgCnt                                      ' Loop through them
            '-----------------------------------------------------------------------------------------------+
            '- Setup the Change command model                                                               |
            '-----------------------------------------------------------------------------------------------+
            CCmd = "CHANGE " + CHR$(96) + FromTxt(v) + CHR$(96) + " " + _   ' Build command
                               CHR$(96) + ToTxt(v)   + CHR$(96) + " ALL DS WORD" '
            Call3(PTBL.ParseCmd(CCmd, %PAll), _                   ' Try the basic parse
                 pCmdHelp("HELP MConvert"), _                     ' ? entered
                 MErrExit(%eFail, PTBL.ErrMsg), _                 ' Error, Bail out
                 Nul)                                             ' Continue

            j = me.Search(0, %CCmd)                               ' Do the initial search
            IF j THEN                                             ' See if we have one
               me.Change()                                        ' Go do the Change
               ONCE = %True                                       ' Remember we changed something
            END IF                                                '
            DO WHILE j                                            ' Do till not found
               j = me.Search(1, %CNext)                           ' Do re-Finds
               IF j THEN                                          '
                  me.Change()                                     '
                  ONCE = %True                                    ' Remember we changed something
               END IF                                             '
            LOOP                                                  '
         NEXT v                                                   '
         IF ONCE THEN INCR AllCount2                              ' Count
         '-----------------------------------------------------------------------------------------+
         '- Now save as the new version                                                            |
         '-----------------------------------------------------------------------------------------+
         CpyIt:
         pCmdCREATE("REPSWAP REPLACE " + $DQ + NewFile + $DQ)     ' Call REPLACE to sve it
      END IF                                                      '
   NEXT i                                                         '
   TP.ErrMsgReset                                                 ' Clear any errors from Edit
   TabMode = %FMTab                                               ' Ensure we're back in FM Mode
   ErrMsgHigh = 0                                                 '
   DIALOG END ghIntr                                              ' End the window
   FCB.SetupProf("DEFAULT", RCA)                                  ' Overlay with DEFAULT if available
   gfInterrupt = %False                                           '
   LastLine = 3                                                   ' Prevent Editor opens (if last file was empty or Skipped outouf)
   MErrExit(%eNone, FORMAT$(AllCount2) + " out of " + FORMAT$(AllCount1) + " .MACRO files in the display were altered")
   EXIT METHOD

   '-----------------------------------------------------------------------------------------------+
   '- These are the 'From' and 'To' strings to be changed                                          |
   '-----------------------------------------------------------------------------------------------+
   DATA "FMGet_Attr$",                "FM.Attr$"
   DATA "FMGet_Attribute",            "FM.Attr#"
   DATA "FMGet_Backup_Versions",      "FM.BackupVersions#"
   DATA "FMGet_Cmd$",                 "FM.Cmd$"
   DATA "FMGet_CreationTime$",        "FM.CreationTime$"
   DATA "FMGet_Extension$",           "FM.Extension$"
   DATA "FMGet_FCount",               "FM.FCount#"
   DATA "FMGet_FileName$",            "FM.FileName$"
   DATA "FMGet_FilePath$",            "FM.FilePath$"
   DATA "FMGet_FilePattern$",         "FM.FilePattern$"
   DATA "FMGet_FileSize",             "FM.FileSize#"
   DATA "FMGet_File_Class",           "FM.FileClass#"
   DATA "FMGet_File_Class",           "FM.FileClass#"
   DATA "FMGet_FListName$",           "FM.FListName$"
   DATA "FMGet_FType",                "FM.FType#"
   DATA "FMGet_LastWriteTime$",       "FM.WriteTime$"
   DATA "FMGet_Lines",                "FM.Lines#"
   DATA "FMGet_Mode",                 "FM.Mode#"
   DATA "FMGet_Path$",                "FM.Path$"
   DATA "FMGet_PRP1$",                "FM.PRP1$"
   DATA "FMGet_PRP2$",                "FM.PRP2$"
   DATA "FMGet_PRP3$",                "FM.PRP3$"
   DATA "FMGet_PRP4$",                "FM.PRP4$"
   DATA "FMGet_PRP5$",                "FM.PRP5$"
   DATA "FMGet_PRP6$",                "FM.PRP6$"
   DATA "Get_ANSI2SOURCE_Table$",     "PRO.ANSI2SourceTable$"
   DATA "Get_ANSI2SOURCE_Table$",     "PRO.ANSI2SourceTable$"
   DATA "Get_Clr_Line$",              "FIL.ClrLine$"
   DATA "Get_Csr_Col",                "SCR.CsrCol#"
   DATA "Get_Csr_LPtr",               "SCR.CsrLPtr#"
   DATA "Get_Curr_Line$",             "SCR.CsrCurrLine$"
   DATA "Get_Curr_Word$",             "SCR.CsrCurrWord$"
   DATA "Get_ENVVAR$",                "ENV.SysVar$"
   DATA "Get_EXE_Path$",              "ENV.EXEPath$"
   DATA "Get_FileBase$",              "FIL.BaseName$"
   DATA "Get_FileDate$",              "FIL.Date$"
   DATA "Get_FileExt$",               "FIL.Ext$"
   DATA "Get_FileFull$",              "FIL.FullName$"
   DATA "Get_FileName$",              "FIL.FileName$"
   DATA "Get_FilePath$",              "FIL.Path$"
   DATA "Get_FileTime$",              "FIL.Time$"
   DATA "Get_First_LPtr",             "FIL.FirstLPtr#"
   DATA "Get_First_Real_LPtr",        "FIL.FirstRealLPtr#"
   DATA "Get_Instance$",              "ENV.Instance$"
   DATA "Get_Last_LPtr",              "FIL.LastLPtr#"
   DATA "Get_Last_Real_LPtr",         "FIL.LastRealLPtr#"
   DATA "Get_LBound",                 "PRO.LBound#"
   DATA "Get_LeftScrn_Col",           "SCR.LeftCol#"
   DATA "Get_Line$",                  "FIL.Line$"
   DATA "Get_MacName$",               "ENV.MacName$"
   DATA "Get_Modified",               "FIL.Modified#"
   DATA "Get_Profile$(""Action"")",   "PRO.Action$"
   DATA "Get_Profile$(""AutoBkup"")", "PRO.AutoBkup$"
   DATA "Get_Profile$(""AutoCaps"")", "PRO.AutoCaps$"
   DATA "Get_Profile$(""AutoName"")", "PRO.AutoName$"
   DATA "Get_Profile$(""Autosave"")", "PRO.AutoSave$"
   DATA "Get_Profile$(""BNDS"")",     "PRO.BNDS$"
   DATA "Get_Profile$(""BNDSLine"")", "PRO.BNDSLine$"
   DATA "Get_Profile$(""BOM"")",      "PRO.BOM$ "
   DATA "Get_Profile$(""Caps"")",     "PRO.Caps$"
   DATA "Get_Profile$(""Case"")",     "PRO.Case$"
   DATA "Get_Profile$(""Change"")",   "PRO.Change$"
   DATA "Get_Profile$(""Collate"")",  "PRO.Collate$"
   DATA "Get_Profile$(""Cols"")",     "PRO.Cols$"
   DATA "Get_Profile$(""Comments"")", "PRO.Comments$"
   DATA "Get_Profile$(""DCB"")",      "PRO.DCB$"
   DATA "Get_Profile$(""EFT"")",      "PRO.EFT$"
   DATA "Get_Profile$(""EMacro"")",   "PRO.EMacro$"
   DATA "Get_Profile$(""EOL"")",      "PRO.EOL$"
   DATA "Get_Profile$(""EOLStr"")",   "PRO.EOLStr$"
   DATA "Get_Profile$(""Hex"")",      "PRO.Hex$"
   DATA "Get_Profile$(""Hide"")",     "PRO.Hide$"
   DATA "Get_Profile$(""Hilite"")",   "PRO.Hilite$"
   DATA "Get_Profile$(""IMacro"")",   "PRO.IMacro$"
   DATA "Get_Profile$(""Include"")",  "PRO.Include$"
   DATA "Get_Profile$(""LBound"")",   "PRO.LBound#"
   DATA "Get_Profile$(""Lock"")",     "PRO.Lock$"
   DATA "Get_Profile$(""LRECL"")",    "PRO.LRECL#"
   DATA "Get_Profile$(""Maclib"")",   "PRO.Maclib$"
   DATA "Get_Profile$(""Mark$"")",    "PRO.Mark$"
   DATA "Get_Profile$(""MarkLine"")", "PRO.MarkLine$"
   DATA "Get_Profile$(""Mask"")",     "PRO.Mask$"
   DATA "Get_Profile$(""MaskLine"")", "PRO.MaskLine$"
   DATA "Get_Profile$(""MinLen"")",   "PRO.MinLen#"
   DATA "Get_Profile$(""Mode"")",     "PRO.Mode$"
   DATA "Get_Profile$(""Name"")",     "PRO.Name$"
   DATA "Get_Profile$(""Notify"")",   "PRO.Notify$"
   DATA "Get_Profile$(""Page"")",     "PRO.Page$"
   DATA "Get_Profile$(""Preserve"")", "PRO.Preserve$"
   DATA "Get_Profile$(""RBound"")",   "PRO.RBound$"
   DATA "Get_Profile$(""RECFM"")",    "PRO.RECFM$"
   DATA "Get_Profile$(""Scroll"")",   "PRO.Scroll$"
   DATA "Get_Profile$(""Source"")",   "PRO.Source$"
   DATA "Get_Profile$(""Start"")",    "PRO.Start$"
   DATA "Get_Profile$(""State"")",    "PRO.State$"
   DATA "Get_Profile$(""SubArg"")",   "PRO.SubArg$"
   DATA "Get_Profile$(""SubCmd"")",   "PRO.SubCmd$"
   DATA "Get_Profile$(""TabBNDS"")",  "PRO.Tabbnds$"
   DATA "Get_Profile$(""Tabs"")",     "PRO.Tabs$"
   DATA "Get_Profile$(""TabsLine"")", "PRO.TabsLine$"
   DATA "Get_Profile$(""Word"")",     "PRO.Word$"
   DATA "Get_Profile$(""XForm"")",    "PRO.XForm$"
   DATA "Get_Profile$(""XTabs"")",    "PRO.XTabs#"
   DATA "Get_RBound",                 "PRO.RBound#"
   DATA "Get_RightScrn_Col",          "SCR.RightCol#"
   DATA "Get_SOURCE2ANSI_Table$",     "PRO.Source2ANSITable$"
   DATA "Get_SOURCE2ANSI_Table$",     "PRO.Source2ANSITable$"
   DATA "Get_TabNum",                 "ENV.Tabnum#"
   DATA "Get_TopScrn_LPtr",           "SCR.TopScrLPtr#"
   DATA "Get_Uniq_ID",                "ENV.UniqID#"
   DATA "Is_FM",                      "ENV.IsFM#"
   DATA "Is_Line_Cmd",                "ENV.IsLineCmd#"
   DATA "Is_Primary_Cmd",             "ENV.IsPrimaryCmd#"

END METHOD                                                        '
